﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_10
{
    class WebSite
    {
        private const string m_http = "http";

        private string fullUrl;

        public string Url { get; set; }

        public bool PredictLocation(ref Location loc)
        {
            bool success = true;

            loc.Lat += 5;
            loc.Lon += 3;

            return success;
        }

        public bool UpdateSite(WebSite site)
        {
            if (!(site.Url.StartsWith(m_http)))
            {
                site.Url = m_http + site.Url;
                return true;
            }
            else
            {
                return false;
            }
        }

        public string EnsureValidUrl(string url)
        {
            string fullUrl;

            if (!(url.StartsWith(m_http)))
            {
                fullUrl = m_http + url;
                this.fullUrl = fullUrl;

                return fullUrl;
            }

            return url;
        }
        
        public bool IsValidUrl(string url)
        {
            if (!(url.StartsWith(m_http)))
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        public bool IsValidUrl(Uri url)
        {
            if (!(url.Scheme.StartsWith(m_http)))
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        public bool IsValidUrl(Uri url, string scheme)
        {
            if (url.Scheme == scheme)
            {
                return true;
            }

            return false;
        }

        public override bool Equals(object obj)
        {
            if (obj == null) return false;
            if (obj.GetType() != typeof(WebSite)) return false;

            return Url == Url;
        }

        public static bool operator ==(WebSite leftSite, WebSite rightSite)
        {
            return leftSite.Equals(rightSite);
        }

        public static bool operator !=(WebSite leftSite, WebSite rightSite)
        {
            return !leftSite.Equals(rightSite);
        }
    }
}
